<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->bigIncrements('Coupon_id'); // bigint UNSIGNED AUTO_INCREMENT PRIMARY KEY
            $table->string('Code', 50)->unique('code_unique'); // varchar(50) NOT NULL UNIQUE
            $table->enum('Discount_type', ['percentage', 'fixed'])->default('percentage'); // enum NOT NULL DEFAULT 'percentage'
            $table->decimal('Discount_value', 10, 2); // decimal(10,2) NOT NULL
            $table->date('Expiry_date'); // date NOT NULL
            $table->integer('Usage_limit')->default(0); // int(11) NOT NULL DEFAULT 0
            $table->integer('Used_count')->default(0); // int(11) NOT NULL DEFAULT 0
            $table->enum('Status', ['active', 'inactive'])->default('active'); // enum NOT NULL DEFAULT 'active'
            $table->unsignedBigInteger('Plan_id')->nullable(); // bigint UNSIGNED NULL
            $table->timestamps(); // Created_at and Updated_at

            // Foreign key
            $table->foreign('Plan_id')->references('Plan_id')->on('plans')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
